/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class WrappingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    protected WrappingExecutorService(ExecutorService delegate) {
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    protected abstract <T> Callable<T> wrapTask(Callable<T> var1);

    protected Runnable wrapTask(Runnable command2) {
        final Callable<Object> wrapped = this.wrapTask(Executors.callable(command2, null));
        return new Runnable(){

            @Override
            public void run() {
                try {
                    wrapped.call();
                }
                catch (Exception e) {
                    Throwables.propagate(e);
                }
            }
        };
    }

    private final <T> ImmutableList<Callable<T>> wrapTasks(Collection<? extends Callable<T>> tasks) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Callable<T> task2 : tasks) {
            builder.add(this.wrapTask(task2));
        }
        return builder.build();
    }

    @Override
    public final void execute(Runnable command2) {
        this.delegate.execute(this.wrapTask(command2));
    }

    @Override
    public final <T> Future<T> submit(Callable<T> task2) {
        return this.delegate.submit(this.wrapTask(Preconditions.checkNotNull(task2)));
    }

    @Override
    public final Future<?> submit(Runnable task2) {
        return this.delegate.submit(this.wrapTask(task2));
    }

    @Override
    public final <T> Future<T> submit(Runnable task2, T result2) {
        return this.delegate.submit(this.wrapTask(task2), result2);
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit2) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks), timeout, unit2);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapTasks(tasks));
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit2) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapTasks(tasks), timeout, unit2);
    }

    @Override
    public final void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public final boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit2) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit2);
    }
}

